/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package examples;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import static java.nio.file.StandardCopyOption.REPLACE_EXISTING;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class AdvancedFileManipulation {
    public static void main(String[] args) {
//        copyContents();
//        listDirectory();
        listSubDirectories();
    }
    public static void copyContents(){
        //Copy contents of file using a stream.
        Path path = Paths.get("DWT website.html");
        URI u = URI.create("https://www.dynamicwebtraining.com.au");
        try (InputStream in = u.toURL().openStream()) {
            Files.copy(in, path, REPLACE_EXISTING);
        } catch (IOException e) {
            System.err.println("Exception: " + e);
        }
    }
    public static void listDirectory(){
        //List the contents of a directory
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get("."), "*")) {
            for (Path file : stream) {
                System.out.println(file.getFileName());
            }
        } catch (PatternSyntaxException | DirectoryIteratorException | IOException x) {
            System.err.println(x);
        }
    }
    public static void listSubDirectories(){
        try {
            Files.walk(Paths.get(".")).forEach(f->System.out.println(f.getFileName()));
        } catch (IOException ex) {
            Logger.getLogger(AdvancedFileManipulation.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}
